using System; 
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Data.SqlClient;

namespace Filter
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		SqlConnection cn;
		SqlCommand cmd;
		SqlDataAdapter da;
		DataSet ds;
		object objDb;
		internal System.Windows.Forms.TextBox txtQYearHigh;
		internal System.Windows.Forms.TextBox txtQYearLow;
		internal System.Windows.Forms.Button btnQuery;
		internal System.Windows.Forms.DataGrid DataGrid1;
		internal System.Windows.Forms.TextBox txtQTitle;
		internal System.Windows.Forms.TabPage TabPage1;
		internal System.Windows.Forms.TextBox txtFilter;
		internal System.Windows.Forms.Button btnFilter;
		internal System.Windows.Forms.Label Label1;
		internal System.Windows.Forms.TabPage TabPage4;
		internal System.Windows.Forms.ComboBox cmbOperator;
		internal System.Windows.Forms.ComboBox cmbFields;
		internal System.Windows.Forms.TextBox txtFilterColumn;
		private System.Windows.Forms.Button btnFilterColumn;
		internal System.Windows.Forms.Label Label4;
		internal System.Windows.Forms.TabPage TabPage2;
		internal System.Windows.Forms.TextBox txtGeneralFilter;
		internal System.Windows.Forms.Button btnGeneralFilter;
		internal System.Windows.Forms.Label Label3;
		internal System.Windows.Forms.TabPage TabPage3;
		internal System.Windows.Forms.RadioButton rbDsc;
		internal System.Windows.Forms.Button btnSort;
		internal System.Windows.Forms.RadioButton rbAsc;
		internal System.Windows.Forms.Label Label2;
		internal System.Windows.Forms.ComboBox cmbSortArg;
		private System.Windows.Forms.TabPage TabFindPage;
		internal System.Windows.Forms.TabControl TabControl1;
		internal System.Windows.Forms.Label Label6;
		internal System.Windows.Forms.TextBox txtPk;
		internal System.Windows.Forms.TextBox txtFind;
		internal System.Windows.Forms.Button btnFind;
		internal System.Windows.Forms.Label Label5;
		internal System.Windows.Forms.Button btnFindArray;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public Form1()
		{
			try
			{
				//
				// Required for Windows Form Designer support
				//
				InitializeComponent();

				//
				// TODO: Add any constructor code after InitializeComponent call
				//

				cn = new SqlConnection("server=.;database=biblio;uid=admin;pwd=pw");

				cmd = new SqlCommand("SELECT ISBN, Title, Year_Published, Price" 
					+ " FROM Titles WHERE (Year_Published BETWEEN @YearLow AND @YearHigh) " 
					+ " AND (Title LIKE @TitleWanted)",cn);



				cmd.CommandType = CommandType.Text;


				cmd.Parameters.Add("@YearLow", SqlDbType.Int).Value = "1900";
				cmd.Parameters.Add("@YearHigh", SqlDbType.Int).Value = "1999";
				cmd.Parameters.Add("@TitleWanted", SqlDbType.VarChar, 20).Value = "Hi%";

				DataGrid1.PreferredColumnWidth = 150;




				da = new SqlDataAdapter(cmd);

				ds = new DataSet();

				RunQuery();
				txtFilter.Text = txtQTitle.Text;
				objDb = DataGrid1.DataSource;
			}
			catch (Exception ex)
			{
				Debug.WriteLine(ex.ToString());
				MessageBox.Show(ex.ToString());
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.txtQYearHigh = new System.Windows.Forms.TextBox();
			this.txtQYearLow = new System.Windows.Forms.TextBox();
			this.btnQuery = new System.Windows.Forms.Button();
			this.DataGrid1 = new System.Windows.Forms.DataGrid();
			this.txtQTitle = new System.Windows.Forms.TextBox();
			this.TabPage1 = new System.Windows.Forms.TabPage();
			this.txtFilter = new System.Windows.Forms.TextBox();
			this.btnFilter = new System.Windows.Forms.Button();
			this.Label1 = new System.Windows.Forms.Label();
			this.TabPage4 = new System.Windows.Forms.TabPage();
			this.cmbOperator = new System.Windows.Forms.ComboBox();
			this.cmbFields = new System.Windows.Forms.ComboBox();
			this.txtFilterColumn = new System.Windows.Forms.TextBox();
			this.btnFilterColumn = new System.Windows.Forms.Button();
			this.Label4 = new System.Windows.Forms.Label();
			this.TabPage2 = new System.Windows.Forms.TabPage();
			this.txtGeneralFilter = new System.Windows.Forms.TextBox();
			this.btnGeneralFilter = new System.Windows.Forms.Button();
			this.Label3 = new System.Windows.Forms.Label();
			this.TabPage3 = new System.Windows.Forms.TabPage();
			this.rbDsc = new System.Windows.Forms.RadioButton();
			this.btnSort = new System.Windows.Forms.Button();
			this.rbAsc = new System.Windows.Forms.RadioButton();
			this.Label2 = new System.Windows.Forms.Label();
			this.cmbSortArg = new System.Windows.Forms.ComboBox();
			this.TabFindPage = new System.Windows.Forms.TabPage();
			this.TabControl1 = new System.Windows.Forms.TabControl();
			this.Label6 = new System.Windows.Forms.Label();
			this.txtPk = new System.Windows.Forms.TextBox();
			this.txtFind = new System.Windows.Forms.TextBox();
			this.btnFind = new System.Windows.Forms.Button();
			this.Label5 = new System.Windows.Forms.Label();
			this.btnFindArray = new System.Windows.Forms.Button();
			((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).BeginInit();
			this.TabPage1.SuspendLayout();
			this.TabPage4.SuspendLayout();
			this.TabPage2.SuspendLayout();
			this.TabPage3.SuspendLayout();
			this.TabFindPage.SuspendLayout();
			this.TabControl1.SuspendLayout();
			this.SuspendLayout();
			// 
			// txtQYearHigh
			// 
			this.txtQYearHigh.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtQYearHigh.Location = new System.Drawing.Point(328, 48);
			this.txtQYearHigh.Name = "txtQYearHigh";
			this.txtQYearHigh.Size = new System.Drawing.Size(104, 22);
			this.txtQYearHigh.TabIndex = 15;
			this.txtQYearHigh.Text = "1999";
			// 
			// txtQYearLow
			// 
			this.txtQYearLow.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtQYearLow.Location = new System.Drawing.Point(208, 48);
			this.txtQYearLow.Name = "txtQYearLow";
			this.txtQYearLow.Size = new System.Drawing.Size(104, 22);
			this.txtQYearLow.TabIndex = 16;
			this.txtQYearLow.Text = "1900";
			// 
			// btnQuery
			// 
			this.btnQuery.Location = new System.Drawing.Point(40, 32);
			this.btnQuery.Name = "btnQuery";
			this.btnQuery.Size = new System.Drawing.Size(96, 24);
			this.btnQuery.TabIndex = 13;
			this.btnQuery.Text = "Query";
			this.btnQuery.Click += new System.EventHandler(this.btnQuery_Click);
			// 
			// DataGrid1
			// 
			this.DataGrid1.AlternatingBackColor = System.Drawing.Color.LightGray;
			this.DataGrid1.BackColor = System.Drawing.Color.DarkGray;
			this.DataGrid1.CaptionBackColor = System.Drawing.Color.White;
			this.DataGrid1.CaptionForeColor = System.Drawing.Color.Navy;
			this.DataGrid1.DataMember = "";
			this.DataGrid1.HeaderForeColor = System.Drawing.SystemColors.ControlText;
			this.DataGrid1.Location = new System.Drawing.Point(0, 224);
			this.DataGrid1.Name = "DataGrid1";
			this.DataGrid1.Size = new System.Drawing.Size(536, 256);
			this.DataGrid1.TabIndex = 17;
			// 
			// txtQTitle
			// 
			this.txtQTitle.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtQTitle.Location = new System.Drawing.Point(208, 16);
			this.txtQTitle.Name = "txtQTitle";
			this.txtQTitle.Size = new System.Drawing.Size(296, 22);
			this.txtQTitle.TabIndex = 12;
			this.txtQTitle.Text = "Hitch%";
			// 
			// TabPage1
			// 
			this.TabPage1.Controls.AddRange(new System.Windows.Forms.Control[] {
																				   this.txtFilter,
																				   this.btnFilter,
																				   this.Label1});
			this.TabPage1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabPage1.Location = new System.Drawing.Point(4, 25);
			this.TabPage1.Name = "TabPage1";
			this.TabPage1.Size = new System.Drawing.Size(512, 91);
			this.TabPage1.TabIndex = 0;
			this.TabPage1.Text = "Filter on Title";
			// 
			// txtFilter
			// 
			this.txtFilter.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFilter.Location = new System.Drawing.Point(120, 24);
			this.txtFilter.Name = "txtFilter";
			this.txtFilter.Size = new System.Drawing.Size(368, 22);
			this.txtFilter.TabIndex = 1;
			this.txtFilter.Text = "";
			// 
			// btnFilter
			// 
			this.btnFilter.Location = new System.Drawing.Point(192, 56);
			this.btnFilter.Name = "btnFilter";
			this.btnFilter.Size = new System.Drawing.Size(96, 24);
			this.btnFilter.TabIndex = 2;
			this.btnFilter.Text = "Filter Title";
			this.btnFilter.Click += new System.EventHandler(this.btnFilter_Click);
			// 
			// Label1
			// 
			this.Label1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label1.Location = new System.Drawing.Point(16, 24);
			this.Label1.Name = "Label1";
			this.Label1.Size = new System.Drawing.Size(88, 24);
			this.Label1.TabIndex = 7;
			this.Label1.Text = "Title like...";
			this.Label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// TabPage4
			// 
			this.TabPage4.Controls.AddRange(new System.Windows.Forms.Control[] {
																				   this.cmbOperator,
																				   this.cmbFields,
																				   this.txtFilterColumn,
																				   this.btnFilterColumn,
																				   this.Label4});
			this.TabPage4.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabPage4.Location = new System.Drawing.Point(4, 25);
			this.TabPage4.Name = "TabPage4";
			this.TabPage4.Size = new System.Drawing.Size(512, 91);
			this.TabPage4.TabIndex = 4;
			this.TabPage4.Text = "Filter on Column";
			// 
			// cmbOperator
			// 
			this.cmbOperator.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbOperator.ItemHeight = 16;
			this.cmbOperator.Items.AddRange(new object[] {
															 "=",
															 ">",
															 "<",
															 "<>",
															 "<=",
															 ">=",
															 "LIKE"});
			this.cmbOperator.Location = new System.Drawing.Point(264, 24);
			this.cmbOperator.Name = "cmbOperator";
			this.cmbOperator.Size = new System.Drawing.Size(56, 24);
			this.cmbOperator.TabIndex = 9;
			// 
			// cmbFields
			// 
			this.cmbFields.DropDownWidth = 144;
			this.cmbFields.ItemHeight = 16;
			this.cmbFields.Location = new System.Drawing.Point(136, 24);
			this.cmbFields.Name = "cmbFields";
			this.cmbFields.Size = new System.Drawing.Size(120, 24);
			this.cmbFields.TabIndex = 8;
			// 
			// txtFilterColumn
			// 
			this.txtFilterColumn.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFilterColumn.Location = new System.Drawing.Point(328, 24);
			this.txtFilterColumn.Name = "txtFilterColumn";
			this.txtFilterColumn.Size = new System.Drawing.Size(160, 22);
			this.txtFilterColumn.TabIndex = 1;
			this.txtFilterColumn.Text = "";
			// 
			// btnFilterColumn
			// 
			this.btnFilterColumn.Location = new System.Drawing.Point(192, 56);
			this.btnFilterColumn.Name = "btnFilterColumn";
			this.btnFilterColumn.Size = new System.Drawing.Size(96, 24);
			this.btnFilterColumn.TabIndex = 2;
			this.btnFilterColumn.Text = "Filter Column";
			this.btnFilterColumn.Click += new System.EventHandler(this.btnFilterColumn_Click);
			// 
			// Label4
			// 
			this.Label4.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label4.Location = new System.Drawing.Point(8, 24);
			this.Label4.Name = "Label4";
			this.Label4.Size = new System.Drawing.Size(96, 32);
			this.Label4.TabIndex = 7;
			this.Label4.Text = "Filter expression";
			this.Label4.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// TabPage2
			// 
			this.TabPage2.Controls.AddRange(new System.Windows.Forms.Control[] {
																				   this.txtGeneralFilter,
																				   this.btnGeneralFilter,
																				   this.Label3});
			this.TabPage2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabPage2.Location = new System.Drawing.Point(4, 25);
			this.TabPage2.Name = "TabPage2";
			this.TabPage2.Size = new System.Drawing.Size(512, 91);
			this.TabPage2.TabIndex = 1;
			this.TabPage2.Text = "General Filter";
			this.TabPage2.Visible = false;
			// 
			// txtGeneralFilter
			// 
			this.txtGeneralFilter.Location = new System.Drawing.Point(112, 24);
			this.txtGeneralFilter.Name = "txtGeneralFilter";
			this.txtGeneralFilter.Size = new System.Drawing.Size(376, 22);
			this.txtGeneralFilter.TabIndex = 1;
			this.txtGeneralFilter.Text = "ISBN = \'0-2015983-0-2\'";
			// 
			// btnGeneralFilter
			// 
			this.btnGeneralFilter.Location = new System.Drawing.Point(192, 56);
			this.btnGeneralFilter.Name = "btnGeneralFilter";
			this.btnGeneralFilter.Size = new System.Drawing.Size(96, 24);
			this.btnGeneralFilter.TabIndex = 2;
			this.btnGeneralFilter.Text = "Filter";
			this.btnGeneralFilter.Click += new System.EventHandler(this.btnGeneralFilter_Click);
			// 
			// Label3
			// 
			this.Label3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label3.Location = new System.Drawing.Point(16, 24);
			this.Label3.Name = "Label3";
			this.Label3.Size = new System.Drawing.Size(88, 24);
			this.Label3.TabIndex = 7;
			this.Label3.Text = "Filter criteria";
			this.Label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// TabPage3
			// 
			this.TabPage3.Controls.AddRange(new System.Windows.Forms.Control[] {
																				   this.rbDsc,
																				   this.btnSort,
																				   this.rbAsc,
																				   this.Label2,
																				   this.cmbSortArg});
			this.TabPage3.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabPage3.Location = new System.Drawing.Point(4, 25);
			this.TabPage3.Name = "TabPage3";
			this.TabPage3.Size = new System.Drawing.Size(512, 91);
			this.TabPage3.TabIndex = 2;
			this.TabPage3.Text = "Sort";
			this.TabPage3.Visible = false;
			// 
			// rbDsc
			// 
			this.rbDsc.Location = new System.Drawing.Point(400, 40);
			this.rbDsc.Name = "rbDsc";
			this.rbDsc.Size = new System.Drawing.Size(96, 16);
			this.rbDsc.TabIndex = 8;
			this.rbDsc.Text = "Descending";
			// 
			// btnSort
			// 
			this.btnSort.Location = new System.Drawing.Point(192, 56);
			this.btnSort.Name = "btnSort";
			this.btnSort.Size = new System.Drawing.Size(96, 24);
			this.btnSort.TabIndex = 2;
			this.btnSort.Text = "Sort";
			this.btnSort.Click += new System.EventHandler(this.btnSort_Click);
			// 
			// rbAsc
			// 
			this.rbAsc.Checked = true;
			this.rbAsc.Location = new System.Drawing.Point(400, 16);
			this.rbAsc.Name = "rbAsc";
			this.rbAsc.Size = new System.Drawing.Size(96, 16);
			this.rbAsc.TabIndex = 8;
			this.rbAsc.TabStop = true;
			this.rbAsc.Text = "Ascending";
			// 
			// Label2
			// 
			this.Label2.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label2.Location = new System.Drawing.Point(16, 24);
			this.Label2.Name = "Label2";
			this.Label2.Size = new System.Drawing.Size(88, 24);
			this.Label2.TabIndex = 7;
			this.Label2.Text = "Sort by...";
			this.Label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// cmbSortArg
			// 
			this.cmbSortArg.DropDownWidth = 176;
			this.cmbSortArg.ItemHeight = 16;
			this.cmbSortArg.Location = new System.Drawing.Point(112, 24);
			this.cmbSortArg.Name = "cmbSortArg";
			this.cmbSortArg.Size = new System.Drawing.Size(272, 24);
			this.cmbSortArg.TabIndex = 9;
			// 
			// TabFindPage
			// 
			this.TabFindPage.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.Label6,
																					  this.txtPk,
																					  this.txtFind,
																					  this.btnFind,
																					  this.Label5,
																					  this.btnFindArray});
			this.TabFindPage.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabFindPage.Location = new System.Drawing.Point(4, 25);
			this.TabFindPage.Name = "TabFindPage";
			this.TabFindPage.Size = new System.Drawing.Size(512, 91);
			this.TabFindPage.TabIndex = 5;
			this.TabFindPage.Text = "Find";
			this.TabFindPage.Enter += new System.EventHandler(this.TabFindPage_Enter);
			// 
			// TabControl1
			// 
			this.TabControl1.Controls.AddRange(new System.Windows.Forms.Control[] {
																					  this.TabPage1,
																					  this.TabPage4,
																					  this.TabPage2,
																					  this.TabPage3,
																					  this.TabFindPage});
			this.TabControl1.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.TabControl1.ItemSize = new System.Drawing.Size(88, 21);
			this.TabControl1.Location = new System.Drawing.Point(8, 96);
			this.TabControl1.Name = "TabControl1";
			this.TabControl1.SelectedIndex = 0;
			this.TabControl1.Size = new System.Drawing.Size(520, 120);
			this.TabControl1.TabIndex = 18;
			// 
			// Label6
			// 
			this.Label6.Font = new System.Drawing.Font("Microsoft Sans Serif", 12F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label6.Location = new System.Drawing.Point(276, 21);
			this.Label6.Name = "Label6";
			this.Label6.Size = new System.Drawing.Size(40, 16);
			this.Label6.TabIndex = 15;
			this.Label6.Text = "=";
			this.Label6.TextAlign = System.Drawing.ContentAlignment.MiddleCenter;
			// 
			// txtPk
			// 
			this.txtPk.Location = new System.Drawing.Point(108, 21);
			this.txtPk.Name = "txtPk";
			this.txtPk.Size = new System.Drawing.Size(160, 22);
			this.txtPk.TabIndex = 14;
			this.txtPk.Text = "";
			// 
			// txtFind
			// 
			this.txtFind.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtFind.Location = new System.Drawing.Point(316, 21);
			this.txtFind.Name = "txtFind";
			this.txtFind.Size = new System.Drawing.Size(176, 22);
			this.txtFind.TabIndex = 10;
			this.txtFind.Text = "";
			// 
			// btnFind
			// 
			this.btnFind.Location = new System.Drawing.Point(100, 53);
			this.btnFind.Name = "btnFind";
			this.btnFind.Size = new System.Drawing.Size(96, 24);
			this.btnFind.TabIndex = 11;
			this.btnFind.Text = "Find";
			this.btnFind.Click += new System.EventHandler(this.btnFind_Click);
			// 
			// Label5
			// 
			this.Label5.Font = new System.Drawing.Font("Microsoft Sans Serif", 9.75F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Label5.Location = new System.Drawing.Point(20, 13);
			this.Label5.Name = "Label5";
			this.Label5.Size = new System.Drawing.Size(88, 32);
			this.Label5.TabIndex = 13;
			this.Label5.Text = "Primary key...";
			this.Label5.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// btnFindArray
			// 
			this.btnFindArray.Location = new System.Drawing.Point(276, 53);
			this.btnFindArray.Name = "btnFindArray";
			this.btnFindArray.Size = new System.Drawing.Size(96, 24);
			this.btnFindArray.TabIndex = 12;
			this.btnFindArray.Text = "Find Array";
			this.btnFindArray.Click += new System.EventHandler(this.btnFindArray_Click);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(536, 486);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.TabControl1,
																		  this.txtQYearHigh,
																		  this.txtQYearLow,
																		  this.btnQuery,
																		  this.DataGrid1,
																		  this.txtQTitle});
			this.Name = "Form1";
			this.Text = "Filter";
			((System.ComponentModel.ISupportInitialize)(this.DataGrid1)).EndInit();
			this.TabPage1.ResumeLayout(false);
			this.TabPage4.ResumeLayout(false);
			this.TabPage2.ResumeLayout(false);
			this.TabPage3.ResumeLayout(false);
			this.TabFindPage.ResumeLayout(false);
			this.TabControl1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		private void RunQuery()
		{
			try
			{
				DataColumn[] dcPk; //(1) As DataColumn
				dcPk = new DataColumn[1];
				// Run query based on current parameter settings
				da.Fill(ds, "Titles");
				dcPk[0] = ds.Tables[0].Columns["ISBN"];
				ds.Tables[0].PrimaryKey = dcPk;
				ds.Tables[0].DefaultView.Sort = "ISBN";
				DataGrid1.DataSource = ds.Tables[0];
				FillSortCriteria();
			}
			catch ( Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}

		private void FillSortCriteria()
		{
			if (cmbSortArg.Items.Count > 0)
			{
				return; 
			}

			foreach (DataColumn dc in ds.Tables[0].Columns)
			{
				cmbSortArg.Items.Add(dc.Caption);
				cmbFields.Items.Add(dc.Caption);
			}
		}

		private void btnQuery_Click(object sender, System.EventArgs e)
		{
			ds.Clear();
			cmd.Parameters[0].Value = txtQTitle.Text;
			cmd.Parameters[1].Value = txtQYearLow.Text;
			cmd.Parameters["@YearHigh"].Value = txtQYearHigh.Text;
			txtFilter.Text = cmd.Parameters[0].Value.ToString();

			RunQuery();
		}

		private void btnFilter_Click(object sender, System.EventArgs e)
		{
			try
			{
				SetFilter("Title like '" + txtFilter.Text + "'");
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}

		private void btnGeneralFilter_Click(object sender, System.EventArgs e)
		{
			try
			{
				SetFilter(txtGeneralFilter.Text);
			}
			catch ( Exception ex)
			{
				MessageBox.Show(ex.ToString()); 		
				Debug.WriteLine(ex.ToString());
			}
		}

		private void btnSort_Click(object sender, System.EventArgs e)
		{
			try
			{
				string strSort;
				if (rbAsc.Checked)
				{
					strSort = cmbSortArg.Text + " ASC";        // Note space after "
				}
				else
				{
					strSort = cmbSortArg.Text + " DESC";     // Note space after "
				}
				ds.Tables[0].DefaultView.Sort = strSort;
				DataGrid1.DataSource = ds.Tables[0].DefaultView;
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}

		}




		private void SetFilter(string strFilterExpression)
		{
			try
			{

				Debug.WriteLine(strFilterExpression);
				DataGrid1.DataSource = objDb;
				ds.Tables[0].DefaultView.RowFilter = strFilterExpression;
				if (ds.Tables[0].DefaultView.Count > 0) 
				{
					DataGrid1.DataSource = ds.Tables[0].DefaultView;
				}
				else
				{
					MessageBox.Show("No titles meet criteria.");
				}

			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.Message + " Remember to use single quotes to frame string operands such as ISBN and Title");
				Debug.WriteLine(ex.ToString());
			}


		}

		private void btnFilterColumn_Click(object sender, System.EventArgs e)
		{
			try
			{
				SetFilter(cmbFields.Text + " " + cmbOperator.Text + txtFilterColumn.Text);
			}
			catch (Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}



		private void btnFind_Click(object sender, System.EventArgs e)
		{
			try
			{

				int intRow;
				intRow = ds.Tables[0].DefaultView.Find(txtFind.Text);    // contains valid ISBN
				DataGrid1.CurrentRowIndex = intRow;

			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}

		private void btnFindArray_Click(object sender, System.EventArgs e)
		{
			try
			{
				int intRow;
				object[] objPkArgs = new object[1];
				objPkArgs[0] = txtFind.Text;     // contains valid ISBN
				intRow = ds.Tables[0].DefaultView.Find(objPkArgs);
				DataGrid1.CurrentRowIndex = intRow;
			}
			catch(Exception ex)
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}

		private void TabFindPage_Enter(object sender, System.EventArgs e)
		{
			try
			{
				if (txtPk.Text == "")
				{
					DataColumn[] dcPk;
					dcPk = ds.Tables[0].PrimaryKey; // Passes back an array of Column objects																	
					if (dcPk.GetUpperBound(0) == -1)
					{
						txtPk.Text = "No Primary Key";
						btnFind.Enabled = false;
					}
					else
					{
						for ( int i = 0; i<= dcPk.GetUpperBound(0);i++)
						{
							txtPk.Text += dcPk[i].ColumnName + " ";
							btnFind.Enabled = true;
						}
					}
				}
			}																																			   
			catch ( Exception ex )
			{
				MessageBox.Show(ex.ToString());
				Debug.WriteLine(ex.ToString());
			}
		}
	}
}